" Unit 4 - Lecture 2 "
"------------------------------------------------------------------------"

"
Understanding Output Of Logistic Regression
"

model = glm(am ~ wt,data = mtcars,
            family = binomial(link = "logit"))

"
1: Fraud
0: Not Fraud
"
model$fitted.values

"------------------------------------------------------------------------"

"
Confidence Interval For Mean / 
Individual Response
"

# Syntax:
predict(<model>,newdata = <data>,
        interval = "<confidence / prediction>")

model = lm(mpg ~ wt + qsec,mtcars)

predict(model,newdata = data.frame(wt = c(3.5,1),
                                   qsec = c(3,1)),
        interval = "prediction")

predict(model,newdata = data.frame(wt = 3.5,
                                   qsec = 3),
        interval = "confidence")


"------------------------------------------------------------------------"

"
Using step() for Forward and Backward selection
"

model0 = lm(mpg ~ 1,mtcars)
model.full = lm(mpg ~ .,mtcars)

model = step(model0,
             scope = list(lower = model0,
                          upper = model.full),
             direction = "forward",
             trace = T)

model = step(model.full,
             scope = list(lower = model0,
                          upper = model.full),
             direction = "backward")



"------------------------------------------------------------------------"

"
ANOVA Test To Compare Simple and Complex Model

H0: Simple model is better
H1: Complex model is better

"

# Syntax:
anova(<simple model> , <complex model>)



model.0 = glm(mpg ~ 1,data = mtcars,
              family = Gamma)

model.1 = glm(mpg ~ wt,data = mtcars,
              family = Gamma)

model.2 = glm(mpg ~ wt + qsec,data = mtcars,
              family = Gamma)

model.3 = glm(mpg ~ wt + qsec + disp,data = mtcars,
              family = Gamma)

anova(model.0,model.2,test = "F")
anova(model.1,model.2,test = "F")
anova(model.2,model.3,test = "F")


"------------------------------------------------------------------------"

" Adding Interaction Effect "

"
Shortcut:
A * B = A + B + A:B

where A:B is the interaction effect between A, B.


A * B * C = A + B + C + A:B + A:C + B:C + A:B:C

"

model = lm(Sepal.Length ~ Petal.Length + Petal.Width,
           iris)

model = lm(Sepal.Length ~ Petal.Length + 
                          Petal.Width +
                          Petal.Length:Petal.Width,
           iris)


summary(model)

model.int = glm(Sepal.Length ~ 
                  Petal.Length*Petal.Width,
           data = iris)


summary(model)

model = glm(Sepal.Length ~ Petal.Length + Petal.Width,
               data = iris)

summary(model)

AIC(model.int)
AIC(model)

anova(model,model.int,test = "F")

"------------------------------------------------------------------------"

"
Gist of PCA
"

"------------------------------------------------------------------------"

"
Exam Questions - Regression Analysis

"

"a."
"
Xi ~ N(mu = 132,sigma = 12.32)
X_bar ~ N(mu = 132,
          sigma = 12.32 / sqrt(20))
"

"b."

mu = 132
sigma = 12.32

set.seed(1947)
X = rnorm(20,mu,sigma)


"c."


KDE = density(X)
Mode = KDE$x[which.max(KDE$y)]


"d."

Mode = c()

set.seed(1947)

for(i in 1:10000){
  
  X = rnorm(20,mu,sigma)
  
  KDE = density(X)
  Mode[i] = KDE$x[which.max(KDE$y)]
  
}


"e."

hist(Mode,ylim = c(0,0.15),
     freq = F)

"f."

lines(seq(100,160,0.5),
      dnorm(seq(100,160,0.5),
            mu,sigma/sqrt(20)),
      col = "red")

"g."
qqnorm(Mode) ; qqline(Mode,col = "red")


"------------------------------------------------------------------------"
